package com.beiming.normandy.event.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.normandy.event.dto.requestdto.MediationInfoReqDTO;
import com.beiming.normandy.event.dto.requestdto.MediationListReqDTO;
import com.beiming.normandy.event.dto.requestdto.MediationStatusCountReqDTO;
import com.beiming.normandy.event.dto.responsedto.MediationInfoResDTO;
import com.beiming.normandy.event.dto.responsedto.MediationListResDTO;
import com.beiming.normandy.event.dto.responsedto.MediationStatusCountResDTO;
import java.util.ArrayList;
import javax.validation.Valid;

public interface MediationInfoApi {

  /**
   * 案件列表查询接口 （如果是去掉关联的调解，被申请人不可以看详情）<br>
   */
  DubboResult<PageInfo<MediationListResDTO>> listMediationInfo(@Valid MediationListReqDTO reqDTO);

  /**
   * 案件列表查询接口(草稿)
   */
  DubboResult<PageInfo<MediationListResDTO>> listMediationInfoDraft(
      @Valid MediationListReqDTO reqDTO);

  /**
   * 单个案件查询接口
   */
  DubboResult<MediationInfoResDTO> getMediationInfo(@Valid MediationInfoReqDTO reqDTO);


  /**
   * 案件详情信息（草稿）
   */
  DubboResult<MediationInfoResDTO> getMediationInfoDraft(MediationInfoReqDTO reqDTO);

  /**
   * 根据userid返回全部,等待调解，正在调解的数量(list)<br>
   */
  DubboResult<ArrayList<MediationStatusCountResDTO>> countMediatorLawCaseStatus(
      @Valid MediationStatusCountReqDTO reqDTO);
}
