package com.beiming.normandy.event.dto;

import com.beiming.normandy.event.enums.CertificateTypeEnums;
import com.beiming.normandy.event.enums.RegisterOriginEnum;
import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@ApiModel(description = "新增调解案件代理用户信息")
public class CaseUserAgentDTO implements Serializable {

  private static final long serialVersionUID = 5045940343509121897L;

  /**
   * id
   */
  private Long id;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 案件用户类型
   */
  private String caseUserType;

  /**
   * 代理人id
   */
  private Long agentUserId;

  /**
   * 代理人姓名
   */
  private String agentName;
  /**
   * 代理人性别
   */
  private String agentSex;

  /**
   * 代理人联系电话
   */
  private String agentPhone;

  /**
   * 代理人身份证号
   */
  private String agentIdCard;

  /**
   * 代理人注册来源
   */
  private RegisterOriginEnum agentRegisterOrigin;

  /**
   * 固定电话
   */
  private String agentTelephone;

  /**
   * 代理人类型
   */
  private String agentTypeParent;

  /**
   * 代理人类型,委托代理人或法定/指定代理人
   */
  private String agentType;

  /**
   * 与当事人关系
   */
  private String relationCode;

  /**
   * 当事人id
   */
  private Long litigantUserId;

  /**
   * 当事人person表id
   */
  private Long litigantPersonId;

  /**
   * 其它证件类型（律师证）
   */
  private CertificateTypeEnums certificateType;

  /**
   * 扩展json串
   */
  private String extendJson;

  /**
   * 其它证件号
   */
  private String certificateNo;

  /**
   * 备注
   */
  private String remark;

  //代理人文书，授权委托书或关系证明文件
  private List<MediationAgentMaterialDTO> relationshipMaterials;


}