package com.beiming.normandy.event.dto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * @Description: 调解案件基本信息实体类
 * @Author: caiwei
 * @Date: Created 2018-06-22
 */
@Data
public class MediationCaseBaseDTO implements Serializable {

  private static final long serialVersionUID = 5582269028656878268L;

  /**
   * 是否已在法院立案：0为否，1为是
   */
  private Boolean docket; // add by djq 2018-11-29

  /**
   * 案件id
   */
  private Long id;

  /**
   * 调解类型（人民调解，行政调解
   */
  private String mediationType;

  /**
   * 案件录入人id
   */
  private Long creatorId;

  /**
   * 案件录入人的身份
   */
  private String creatorType;

  /**
   * 案件编号
   */
  private String caseNo;

  /**
   * 视频表id
   */
  private Long videoId;

  /**
   * 状态码(05纠纷被拒绝受理等)
   */
  private String lawCaseStatus;

  /**
   * 咨询纠纷id，咨询转立案存入该值
   */
  private Long disputesId;

  /**
   * 纠纷类型字典表code
   */
  private String disputeTypeCode;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 省份名称
   */
  private String provName;

  /**
   * 城市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 调解员id
   */
  private Long mediatorId;

  /**
   * 调解员名称
   */
  private String mediatorName;

  /**
   * 案件来源。本平台录入； 第三方平台导入。网上立案系统导入，律师平台导入
   */
  private String origin;


  /**
   * 调解开始时间
   */
  private Date startTime;

  /**
   * 调解结束时间
   */
  private Date endTime;

  /**
   * 案件完成时间
   */
  private Date caseCompleteTime;

  /**
   * 重新分配的标签
   */
  private String tab;

  /**
   * 选择性短信发送功能
   */
  private Integer smsOff;

  /**
   * 申请人诉求
   */
  private String appeal;

  /**
   * 纠纷描述
   */
  private String disputeContent;

  /**
   * 重新分配的详细内容
   */
  private String tabDetail;

  /**
   * 案件类型
   */
  private String caseType;

}
