package com.beiming.normandy.event.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 转移调解机构请求类
 *
 * @author qsh
 * @data 2018年7月4日
 */
@Data
public class TransferMediationReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  @NotNull(message = "案件id不能为空")
  private List<Long> caseIds;
  @NotNull(message = "组织机构id不能为空")
  private Long orgId;
  private String detailRason;
  private Long userId;
  private String userName;

  /**
   * 案件归属
   */
  private String caseAttribution;

  /**
   * 角色
   */
  private String roleType;
  
  private Long actDeButtonId;
}
