package com.beiming.normandy.event.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * Created by zli on 2019/1/28.
 *
 * 按照案件里的人员类型来删除
 */
@Setter
@Getter
@NoArgsConstructor
public class UserIdListReqDTO extends CaseIdReqDTO implements Serializable {

  private static final long serialVersionUID = 6871989281828819536L;
  /**
   * 用户ID
   */
  private List<Long> userIdList;

  /**
   * 案件用户类型
   */
  private String caseUserType;

  public UserIdListReqDTO(Long caseId, List<Long> userIdList, String caseUserType) {
    super(caseId);
    this.userIdList = userIdList;
    this.caseUserType = caseUserType;
  }

  @Override
  public String toString() {
    return "UserIdListReqDTO{"
        + "userIdList=" + userIdList
        + ", caseUserType='" + caseUserType + '\''
        + "} " + super.toString();
  }
}
