package com.beiming.normandy.event.dto.requestdto.dispute;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 客服受理咨询,保存客服的聊天人员关系
 * @Date: Created 2018-06-30 21:18
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputesCustomerRelationReqDTO implements Serializable {


  private static final long serialVersionUID = 452189011567365614L;

  @NotBlank(message = "纠纷ID不可空")
  private String id;

  @NotBlank(message = "客服ID不可为空")
  private String customerId;

  @NotBlank(message = "客服姓名不可为空")
  private String customerName;

  @NotBlank(message = "聊天房间号")
  private String roomId;

}
