package com.beiming.normandy.event.dto.requestdto.flowable;

import com.beiming.framework.page.PageQuery;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(description = "请求参数——获取激活task列表")
public class ListPendingCaseReqDTO extends PageQuery implements Serializable {
  
  @ApiModelProperty(position = 1, notes = "搜索条件（包括编号、名字、案号）")
  private String keyWord;
  @ApiModelProperty(position = 10, notes = "纠纷类型")
  private String disputeType;
  @ApiModelProperty(position = 20, notes = "案件状态")
  private String bussinessStatus;
  @ApiModelProperty(position = 30, notes = "案件来源")
  private String creatorType;
  @ApiModelProperty(position = 40, notes = "登记时间从(yyyy-MM-dd)")
  private String startRegisterTime;
  @ApiModelProperty(position = 50, notes = "登记时间到(yyyy-MM-dd)")
  private String endRegisterTime;
  
  @ApiModelProperty(position = 1000, notes = "角色类型")
  @NotNull(message = "角色类型不存在")
  private String roleType;
  @ApiModelProperty(position = 1010, notes = "角色ID")
  @NotNull(message = "角色ID不存在")
  private Long roleId;
  @ApiModelProperty(position = 1020, notes = "用户ID")
  @NotNull(message = "用户ID不存在")
  private Long userId;


}
