package com.beiming.normandy.event.dto.responsedto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * @Description: 案件附件返回
 * @Author: caiwei
 * @Date: Created 2018-06-28
 */
@Data
@ApiModel(description = "文件信息")
public class CaseMaterialResDTO implements Serializable {

  private static final long serialVersionUID = 8828835570650670169L;

  // id主键
  @ApiModelProperty(notes = "材料ID", example = "484")
  private Long id;

  // 附件大分类
  @ApiModelProperty(notes = "材料类别", example = "MEDIATION")
  private String categoryBig;

  // 附件中分类
  @ApiModelProperty(notes = "材料类型", example = "IDENTITY_CERTIFICATE")
  private String categoryMiddle;

  // 文件类型
  @ApiModelProperty(notes = "文书类型", example = "AUTHORIZE_PROXY")
  private String sign;

  // 文件id
  @ApiModelProperty(notes = "文件ID", example = "48433")
  private String fileId;

  // 文件名称
  @ApiModelProperty(notes = "材料名称", example = "合同1.jpg")
  private String fileName;

  // 上传者
  @ApiModelProperty(notes = "材料所有人名字", example = "张三")
  private String userName;

  // 上传者id
  @ApiModelProperty(notes = "材料所有人ID", example = "100000")
  private Long userId;

  //上传来源
  @ApiModelProperty(notes = "PC:web上传，WECHAT：小程序，QRCODE：扫描二维码上传", example = "PC")
  private String origin;

  //上传时间
  @ApiModelProperty(notes = "上传时间")
  private String createTime;

  @ApiModelProperty(notes = "文件路径", example = "hebeiodr/221/165/ico.aGViZWlvZHJfYmFhYzMzMjRlMjFkNDM1NGI0YmIzOGI1MjQ4ZmJjZDg=.jpg")
  private String filePath;

  @ApiModelProperty(notes = "案件代理人personID")
  private Long agentPersonId;

  @ApiModelProperty(notes = "案件人ID")
  private Long caseUserId;

}
