package com.beiming.normandy.event.dto.responsedto;

import com.beiming.framework.util.StringUtils;
import com.beiming.normandy.event.dto.CaseUserAgentDTO;
import com.beiming.normandy.event.dto.MediationCasePersonnelDTO;
import com.beiming.normandy.event.dto.MediationCaseProgressDTO;
import com.beiming.normandy.event.dto.PetitionAgentDTO;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

/**
 * 调解信息查看响应参数
 *
 * @author DJQ 2018年6月27日
 */
@Data
@NoArgsConstructor
public class MediationInfoResDTO implements Serializable {

  private static final long serialVersionUID = -2185513732200103145L;

  private String currentCaseUserType; // 当前用户案件内的角色类型

  /**
   * 是否已在法院立案：0为否，1为是
   */
  private Boolean docket; // add by djq 2018-11-29

  private Long caseId; // 案件ID
  private String caseNo; // 案件号
  private String creatorType; // 案件录入人的身份
  private Long creatorId;
  private Long createTime; // 登记时间
  private Long startTime; // 机构受理时间
  private Long updateTime; // 更新时间
  private String lawCaseStatus; // 案件状态
  private String lawCaseStatusCode; // 案件状态
  private String caseRank;  //案件级别：0:特别重大，1:重大，2:较大，3:一般
  private Long planId;  //预案id
  private String planName;  //预案名称

  private String origin; // 案件来源
  private Long orgId; // 调解机构ID
  private String orgName; // 调解机构
  private String orgAreaCode; // 调解机构区域Code
  private String appeal; // 申请人诉求

  private String mediationType; // 调解类型
  private String disputeType; // 纠纷类型
  private String disputeTypeCode; // 纠纷类型Code
  private String disputeContent; // 纠纷描述

  private String provCode; // 发生地代号：省
  private String cityCode; // 发生地代号：市
  private String areaCode; // 发生地代号：区
  private String streetCode; // 发生地代号：街道
  private String communityCode; // 生地代号：社区

  private String provName; // 发生地名称：省
  private String cityName; // 发生地名称：市
  private String areaName; // 发生地名称：区
  private String streetName; // 发生地名称：街道
  private String communityName; // 发生地名称：社区
  private String address; // 详细地址

  /**
   * 选择性短信发送功能
   */
  private Integer smsOff;

  private List<MediationCasePersonnelDTO> applicants; // 申请人 + agentApplicants 申请人代理人
  private List<MediationCasePersonnelDTO> respondents; // 被申请人 + agentRespondents 被申请人代理人
  private PetitionAgentDTO petitionAgentUser; // 信访代理人
  private List<MediationStaffResDTO> mediators; // 调解员
  private List<MediationCaseProgressDTO> progress; // 案件进度

  /**
   * 记录的状态
   */
  private Integer status;

  /**
   * 机构信息
   */
  private List<MediationInfoSyncOrgsResDTO> syncOrgInfos;

  /**
   * 审批情况，ApprovalSituationEnum
   */
//  private String approvalSituation;
  /**
   * 案件详细状态
   */
  private String detailedStatus;

  /**
   * 行政行为code
   */
//  private String istrativeActCode;

  /**
   * 行政行为名称
   */
//  private String istrativeActName;

  /**
   * 行政管理主体code
   */
//  private String istrativeManageSubjectCode;

  /**
   * 行政管理主体名称
   */
//  private String istrativeManageSubjectName;

  /**
   * 行政管理具体code
   */
//  private String istrativeManageSpecificCode;

  /**
   * 行政管理具体名称
   */
//  private String istrativeManageSpecificName;

  /**
   * 是否行政赔偿0否1是
   */
//  private Integer isCompensation;

  /**
   * 案件类型
   */
  private String caseType;

  /**
   * 调解室房间id
   */
  private Long videoId;

  /**
   * 案件办理信息
   */
  private String handlingInfo;

  /**
   * 法院code
   */
  private String courtCode;

  /**
   * 法院名字
   */
  private String courtName;

  private String syncThird;

  private Date registrationTime;
  /**
   * 审核员
   */
  private String auditorName;
  /**
   * 标的金额
   */
  private BigDecimal caseAmount;

  private String procDefId;

  private String procInstId;

  private String formId;

  private List<String> eventList;

  private String extendJson;

  /**
   * 当前节点角色
   */
  private String currentNodeRole;

  private Date handUpTime;

  /**
   * 纠纷难易程度code
   */
  private String difficultyDisputeCode;
  /**
   * 纠纷难易程度名称
   */
  private String difficultyDisputeName;

  /**
   * 二维码
   */
  private String qrCodeImage;
  /**
   * 是否上链
   */
  private Boolean isUpBlockChain;

  /**
   * 案件到期时间
   */
  private Date caseCompleteTime;
  private Date endTime;

  /**
   * 案件来源
   */
  @ApiModelProperty(notes = "案件来源中文名", example = "用户申请")
  private String creatorTypeName;

  /**
   * 申请人
   */
  @ApiModelProperty(notes = "申请人")
  private String applicantName;

  /**
   * 申请人id
   */
  @ApiModelProperty(notes = "申请人id")
  private List<Long> applicantIds;

  /**
   * 申请人代理人
   */
  @ApiModelProperty(notes = "申请人代理人")
  private String applicantAgentName;

  /**
   * 申请人代理人id
   */
  @ApiModelProperty(notes = "申请人代理人id")
  private List<Long> applicantAgentIds;

  /**
   * 被申请人
   */
  @ApiModelProperty(notes = "被申请人")
  private String respondentName;

  /**
   * 被申请人id
   */
  @ApiModelProperty(notes = "被申请人id")
  private List<Long> respondentIds;

  /**
   * 被申请人代理人
   */
  @ApiModelProperty(notes = "被申请人代理人")
  private String respondentAgentName;

  /**
   * 被申请人代理人id
   */
  @ApiModelProperty(notes = "被申请人代理人id")
  private List<Long> respondentAgentIds;

  public void setPersons() {
    String applicantName = "";
    String applicantAgentName = "";
    List<Long> applicantIds = new ArrayList<Long>();
    List<Long> applicantAgentIds = new ArrayList<Long>();
    if (!CollectionUtils.isEmpty(this.applicants)) {
      for (MediationCasePersonnelDTO mediationCasePersonnelDTO : this.applicants) {
        if (StringUtils.isNotEmpty(applicantName)) {
          applicantName = applicantName + (StringUtils.isEmpty(mediationCasePersonnelDTO.getName()) ? ""
              : "," + mediationCasePersonnelDTO.getName());
        } else {
          applicantName = applicantName + (StringUtils.isEmpty(mediationCasePersonnelDTO.getName()) ? ""
              : mediationCasePersonnelDTO.getName());
        }
        // 处理申请人代理人姓名拼接
        if (!CollectionUtils.isEmpty(mediationCasePersonnelDTO.getCaseUserAgentList())) {
          applicantAgentName = getCaseUserName(applicantAgentName, applicantAgentIds, mediationCasePersonnelDTO);
        }

        if (mediationCasePersonnelDTO.getUserId() != null) {
          applicantIds.add(mediationCasePersonnelDTO.getUserId());
        }
      }
    }
    this.applicantName = applicantName;
    this.applicantAgentName = applicantAgentName;
    this.applicantIds = applicantIds;
    this.applicantAgentIds = applicantAgentIds;
    String respondentName = "";
    String respondentAgentName = "";
    List<Long> respondentIds = new ArrayList<Long>();
    List<Long> respondentAgentIds = new ArrayList<Long>();
    if (!CollectionUtils.isEmpty(this.getRespondents())) {
      for (MediationCasePersonnelDTO mediationCasePersonnelDTO : this.getRespondents()) {
        if (StringUtils.isNotEmpty(respondentName)) {
          respondentName = respondentName + (StringUtils.isEmpty(mediationCasePersonnelDTO.getName()) ? ""
              : "," + mediationCasePersonnelDTO.getName());
        } else {
          respondentName = respondentName + (StringUtils.isEmpty(mediationCasePersonnelDTO.getName()) ? ""
              : mediationCasePersonnelDTO.getName());
        }

        // 处理被申请人代理人姓名拼接
        if (!CollectionUtils.isEmpty(mediationCasePersonnelDTO.getCaseUserAgentList())) {
          respondentAgentName = getCaseUserName(respondentAgentName, respondentAgentIds, mediationCasePersonnelDTO);
        }

        if (mediationCasePersonnelDTO.getUserId() != null) {
          respondentIds.add(mediationCasePersonnelDTO.getUserId());
        }
      }
    }
    this.respondentName = respondentName;
    this.respondentAgentName = respondentAgentName;
    this.respondentIds = respondentIds;
    this.respondentAgentIds = respondentAgentIds;
  }

  private String getCaseUserName(String userName, List<Long> userAgentIds,
      MediationCasePersonnelDTO mediationCasePersonnelDTO) {
    for (CaseUserAgentDTO caseUserAgentDTO : mediationCasePersonnelDTO.getCaseUserAgentList()) {
      if (StringUtils.isNotEmpty(userName)) {
        userName = userName + (StringUtils.isEmpty(caseUserAgentDTO.getAgentName()) ? ""
            : "," + caseUserAgentDTO.getAgentName());
      } else {
        userName = userName + (StringUtils.isEmpty(caseUserAgentDTO.getAgentName()) ? ""
            : caseUserAgentDTO.getAgentName());
      }
      if (caseUserAgentDTO.getAgentUserId() != null) {
        userAgentIds.add(caseUserAgentDTO.getAgentUserId());
      }
    }
    return userName;
  }
}
