package com.beiming.normandy.event.dto.responsedto;

import com.beiming.normandy.event.dto.MediationActualResDTO;
import com.beiming.normandy.event.dto.MediationCasePersonnelDTO;
import com.beiming.normandy.event.dto.MediationCaseProgressDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 调解列表
 *
 * @author DJQ 2018年6月24日
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationListResDTO implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  /**
   * 是否已在法院立案：0为否，1为是
   */
  private Boolean docket; // add by djq 2018-11-29

  private Long caseId; // 案件ID
  private String caseNo; // 案件号
  private String thirdCaseNo; // 登字号
  private Date createTime; // 登记时间
  private Date updateTime; // 更新时间
  private String lawCaseStatus; // 案件状态

  private String origin; // 案件来源
  private Long orgId; // 机构ID
  private String orgName; // 调解机构
  private String appeal; // 申请人诉求

  private String mediationType; // 调解类型
  private String disputeType; // 纠纷类型
  private String disputeContent; // 纠纷描述
  /**
   * 纠纷类型名
   */
  private String disputeTypeName;

  private Long creatorId; // 案件录入人的ID
  private String creatorType; // 案件录入人的身份
  private Date startTime; // 调解开始时间

  private String provCode; // 发生地代号：省
  private String cityCode; // 发生地代号：市
  private String areaCode; // 发生地代号：区
  private String streetCode; // 发生地代号：街道
  private String communityCode; // 发生地代号：社区

  private String provName; // 发生地名称：省
  private String cityName; // 发生地名称：市
  private String areaName; // 发生地名称：区
  private String streetName; // 发生地名称：街道
  private String communityName; // 发生地名称：社区
  private String address; // 详细地址

  private Boolean allowCancel; // 是否允许撤回 true允许撤回，false不允许撤回（默认为false）

  private List<MediationCaseProgressDTO> progress; // 案件进度

  private List<MediationCasePersonnelDTO> applicants; // 申请人
  private List<MediationCasePersonnelDTO> respondents; // 被申请人
  private List<MediationActualResDTO> mediators; // 调解员

  private Long petitionAgentUserId; // 信访代理人Id
  private String petitionAgentUserName; // 信访代理人名字

  private String difficultyDisputeCode; // 纠纷难易程度code
  private String difficultyDisputeName; // 纠纷难易程度名称
  private Long videoId; // 异步调节调解室id
  private String caseType; // 案件类型

  /**
   * 案件到期时间
   */
  private Date caseCompleteTime;
  private Date endTime;

  /**
   * 案件同步到哪一个第三方
   */
  private String syncThird;
  
  /**
   * 流程实例id
   */
  private String procInstId;
  /**
   * 表单id
   */
  private String formId;
  
  private String extendJson;

  private String createUser;
  /**
   * 二维码
   */
  private String qrCodeImage;
  /**
   * 是否上链
   */
  private Boolean isUpBlockChain;

}
