package com.beiming.normandy.event.enums;

/**
 * 案件类型
 *
 * @author huaisf
 */
public enum CaseTypeEnum {

  /**
   * 普通案件
   */
  NORMAL_CASE("普通案件", "普", "诉前调解"),

  /**
   * 简易案件
   */
  SIMPLE_CASE("简易案件", "简"),

  MICRO_CASE("小额速调", "速"),

  LETTER_CASE("信访", "信访", "信访"),

  COMPLAINT_CASE("投诉", "投诉", "12345诉求"),

  LEGAL_AID_CASE("法律援助", "法律援助", "法律援助"),

  LABOR_ARBITRATION_CASE("劳动仲裁", "劳动仲裁", "劳动仲裁"),

  LABOR_SUPERVISION_CASE("劳动监察", "劳动监察", "劳动监察"),

  POLICE_MEDIATION_CASE("警调", "警调", "警调"),

  OTHER_APPEAL_CASE("其他诉求", "其他诉求", "其他诉求"),

  SFJ_CASE("司法局调解", "司法局调解", "司法局调解"),

  THREE_CONSTRUCTION_CASE("三建联动", "三建联动", "三建联动"),

  FY_CASE("法院", "法院", "法院"),

  ;


  private String name;

  private String shortName;

  private String newName;

  CaseTypeEnum(String name, String shortName) {
    this.name = name;
    this.shortName = shortName;
  }

  CaseTypeEnum(String name, String shortName, String newName) {
    this.name = name;
    this.shortName = shortName;
    this.newName = newName;

  }

  public String getName() {
    return name;
  }

  public String getShortName() {
    return shortName;
  }

  public String getNewName() {
    return newName;
  }

  public static String getCaseTypeName(String caseTypeCode) {
    String caseTypeName = "";
    for (CaseTypeEnum e : CaseTypeEnum.values()) {
      if (e.name().equals(caseTypeCode)) {
        caseTypeName = e.getName();
      }
    }
    return caseTypeName;
  }

}
