package com.beiming.normandy.event.enums;

import java.util.Arrays;

/**
 * 调解枚举类型
 *
 * @author qsh
 * @data 2018年7月17日
 */
public enum MeetingTypeEnum {

  MEETING_SURVEY("调查"), MEETING_MEDIATE("调解"), MEETING_CONSULT("会商");
  private final String name;

  /**
   *
   */
  MeetingTypeEnum(String name) {
    this.name = name;
  }

  /**
   * 根据name()来搜索
   */
  public static MeetingTypeEnum getByName(String enumName) {
    return Arrays.stream(MeetingTypeEnum.values())
        .filter(switchEnum -> switchEnum.name().equals(enumName))
        .findFirst()
        .orElse(null);
  }

  public String getName() {
    return name;
  }

  /**
   * 根据meetingType来搜索
   */
  public static MeetingTypeEnum getByMeetingType(String meetingType) {
    if (MeetingTypeNewEnum.MEETING_ORDER_ONLINE.name().equals(meetingType)) {
      return MeetingTypeEnum.MEETING_MEDIATE;
    }
    if (MeetingTypeNewEnum.MEETING_ORDER_CONSULT.name().equals(meetingType)) {
      return MeetingTypeEnum.MEETING_CONSULT;
    }
    return MeetingTypeEnum.MEETING_MEDIATE;
  }
}
