package com.beiming.normandy.event.dto.requestdto;

import java.io.Serializable;
import lombok.Data;

/**
 * @Description: 撤回案件请求参数
 * @Author: caiwei
 * @Date: Created 2018-07-13
 */
@Data
public class CancelCaseReqDTO implements Serializable {

  private static final long serialVersionUID = -630601399298676701L;
  /**
   * 案件id
   */
  private Long caseId;

  /**
   * 案件状态
   */
  private String caseStatus;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 用户名
   */
  private String userName;

  /**
   * 原因类型
   */
  private String reasonType;

  /**
   * 详细原因
   */
  private String detailReason;

  /**
   * 撤回人员角色(1:创建人撤回案件 2:调解员撤回案件)
   */
  private int cancelUserRole;

}
