package com.beiming.normandy.event.dto.requestdto;

import com.beiming.normandy.event.dto.MediationCasePersonnelDTO;
import com.beiming.normandy.event.dto.responsedto.CaseProtocolPersonnelResDTO;
import com.beiming.normandy.event.enums.CaseUserTypeEnum;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;

/**
 * @Description: 案件协议人员请求参数
 * @Author: caiwei
 * @Date: Created 2018-07-01
 */
@Data
@AllArgsConstructor
public class CaseProtocolPersonnelReqDTO implements Serializable {

  private static final long serialVersionUID = 7988498493297314452L;


  // 案件人员类型
  private CaseUserTypeEnum caseUserType;

  // 用户类型
  private String userType;

  // 用户id
  private Long userId;

  // 用户姓名
  private String userName;


  // 人员id
  private Long personnelId;

  // 案件id
  private Long caseId;

  // 文书id
  private Long documentId;

  // 手机号
  private String phone;

  // 性别
  private String sex;

  // 身份证号
  private String idCard;

  // 省份code
  private String provCode;

  // 城市code
  private String cityCode;

  // 区code
  private String areaCode;

  // 街道code
  private String streetCode;

  // 省份名称
  private String provName;

  // 城市名称
  private String cityName;

  // 区名称
  private String areaName;

  // 街道名称
  private String streetName;

  // 详细地址
  private String address;

  // 信用代码
  private String creditCode;

  // 法人代表
  private String corporation;

  // 排序
  private Integer order;

//  /**
//   * 代理人id
//   */
//  private Long agentId;
//
//  /**
//   * 代理人类型
//   */
//  private String agentType;
//
//  /**
//   * 代理人姓名
//   */
//  private String agentName;
//
//  /**
//   * 代理人性别
//   */
//  private String agentSex;
//
//  /**
//   * 代理人身份证
//   */
//  private String agentIdCard;
//
//  /**
//   * 代理人手机号
//   */
//  private String agentPhone;

  /**
   * 其它联系电话
   */
  private String contactPhone;
  /**
   * 联系方式类型 字典表中contact_type的子集
   */
  private String contactType;

  /**
   * 代理人固定电话
   */
  // private String agentTelephone;

  /**
   * 固定电话
   */
  private String telephone;

  //代理人列表
  private List<CaseProtocolAgentPersonnelReqDTO> agentList;

  public CaseProtocolPersonnelReqDTO() {
    // xx
  }

  /**
   * 不对ID类设值PersonnelId、CaseId、DocumentId
   */
  public CaseProtocolPersonnelReqDTO(MediationCasePersonnelDTO casePer) {
    // this.setPersonnelId(null);
    // this.setCaseId(null);
    // this.setDocumentId(null);
    this.setUserId(casePer.getUserId());
    this.setUserType(casePer.getUserType());
    this.setPhone(casePer.getPhone());
    this.setCaseUserType(CaseUserTypeEnum.valueOf(casePer.getCaseUserType()));
    this.setUserName(casePer.getName());
    this.setSex(casePer.getSex());
    this.setIdCard(casePer.getIdCard());
    this.setProvCode(casePer.getProvCode());
    this.setCityCode(casePer.getCityCode());
    this.setAreaCode(casePer.getAreaCode());
    this.setStreetCode(casePer.getStreetCode());
    this.setProvName(casePer.getProvName());
    this.setCityName(casePer.getCityName());
    this.setAreaName(casePer.getAreaName());
    this.setStreetName(casePer.getStreetName());
    this.setAddress(casePer.getAddress());
    this.setOrder(casePer.getUserOrder());
    /*this.setAgentId(casePer.getAgentId());
    this.setAgentIdCard(casePer.getAgentIdCard());
    this.setAgentName(casePer.getAgentName());
    this.setAgentPhone(casePer.getAgentPhone());
    this.setAgentSex(casePer.getAgentSex());
    this.setAgentType(casePer.getAgentType());*/
    this.setCorporation(casePer.getCorporation());
  }

  public CaseProtocolPersonnelReqDTO(MediationPersonalReqDTO casePer) {
    this.setUserId(casePer.getUserId());
    this.setCaseUserType(CaseUserTypeEnum.valueOf(casePer.getCaseUserType()));
    this.setUserName(casePer.getName());
  }

  /**
   * 不对ID类设值PersonnelId、CaseId、DocumentId
   */
  public CaseProtocolPersonnelReqDTO(CaseProtocolPersonnelResDTO casePer) {
    // this.setPersonnelId(null);
    // this.setCaseId(null);
    // this.setDocumentId(null);
    this.setUserId(casePer.getUserId());
    this.setUserType(casePer.getUserType());
    this.setPhone(casePer.getPhone());
    this.setCaseUserType(CaseUserTypeEnum.valueOf(casePer.getCaseUserType()));
    this.setUserName(casePer.getUserName());
    this.setSex(casePer.getSex());
    this.setIdCard(casePer.getIdCard());
    this.setProvCode(casePer.getProvCode());
    this.setCityCode(casePer.getCityCode());
    this.setAreaCode(casePer.getAreaCode());
    this.setStreetCode(casePer.getStreetCode());
    this.setProvName(casePer.getProvName());
    this.setCityName(casePer.getCityName());
    this.setAreaName(casePer.getAreaName());
    this.setStreetName(casePer.getStreetName());
    this.setAddress(casePer.getAddress());
    this.setOrder(casePer.getUserOrder());
//    this.setAgentId(casePer.getAgentId());
//    this.setAgentIdCard(casePer.getAgentIdCard());
//    this.setAgentName(casePer.getAgentName());
//    this.setAgentPhone(casePer.getAgentPhone());
//    this.setAgentSex(casePer.getAgentSex());
//    this.setAgentType(casePer.getAgentType());
    this.setCorporation(casePer.getCorporation());
  }

  /**
   * 不对ID类设值PersonnelId、CaseId、DocumentId<br> 不对Order排序设值
   */
  public CaseProtocolPersonnelReqDTO(MediationDissentSaveReqDTO reqDTO) {
    this.setUserId(reqDTO.getUserId());
    this.setPhone(reqDTO.getPhone());
    this.setUserType(reqDTO.getUserType());
    this.setCaseUserType(CaseUserTypeEnum.valueOf(reqDTO.getCaseUserType()));
    this.setUserName(reqDTO.getUserName());
    this.setSex(reqDTO.getSex());
    this.setIdCard(reqDTO.getIdCard());
    this.setProvCode(reqDTO.getProvCode());
    this.setCityCode(reqDTO.getCityCode());
    this.setAreaCode(reqDTO.getAreaCode());
    this.setStreetCode(reqDTO.getStreetCode());
    this.setProvName(reqDTO.getProvName());
    this.setCityName(reqDTO.getCityName());
    this.setAreaName(reqDTO.getAreaName());
    this.setStreetName(reqDTO.getStreetName());
    this.setAddress(reqDTO.getAddress());
  }

}
