package com.beiming.normandy.event.dto.requestdto;

import com.beiming.normandy.event.dto.responsedto.TempMediatorInfoReqDTO;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * @Description: 保存临时调解员信息
 * @Author: fanheshui
 * @Date: Created 2019-01-23
 */
@Data
public class SaveTempMediatorReqDTO implements Serializable {

  private static final long serialVersionUID = 5852471887298393091L;

  /**
   * 用户添加房间成员
   */
  @NotNull(message = "当前登录的用户Id,不能为空")
  private Long currLoginUserId;
  /**
   * 用户添加房间成员
   */
  @NotNull(message = "当前登录的用户姓名")
  private String currUserName;


  @NotNull(message = "会议id不能为空")
  private Long caseMeetingId;

  @NotNull(message = "调解员信息列表不能为空")
  @Valid
  private List<TempMediatorInfoReqDTO> mediatorInfo;
}
