package com.beiming.normandy.event.dto.requestdto.dispute;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputeRoomMemberReqDTO implements Serializable {


  private static final long serialVersionUID = 4004023240922906637L;

  public DisputeRoomMemberReqDTO(Long disputeId, String memberId) {
    this.disputeId = disputeId;
    this.memberId = memberId;
  }

  @NotNull(message = "纠纷id不允许为空")
  private Long disputeId;

  //@NotBlank(message = "房间id不允许为空")
  /**
   * services层会查询出来赋值
   */
  private String roomId;
  @NotBlank(message = "成员id不允许为空")
  private String memberId;

}