package com.beiming.normandy.event.dto.requestdto.dispute;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 选择咨询师,保存聊天人员关系
 * @Date: Created 2018-06-30 21:18
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputesUserRelationReqDTO implements Serializable {


  private static final long serialVersionUID = 460271481158618093L;

  @NotBlank(message = "纠纷ID不可空")
  private String id;

  @NotBlank(message = "用户ID不可为空")
  private String userId;

  @NotBlank(message = "用户姓名不可为空")
  private String userName;

  @NotBlank(message = "咨询师ID不可为空")
  private String counselorId;

  @NotBlank(message = "咨询师姓名不可为空")
  private String counselorName;

}
