package com.beiming.normandy.event.dto.responsedto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 临时调解员信息请求参数实体类
 * @Author: fanheshui
 * @Date: 2019/1/23
 */
@Data
@NoArgsConstructor
public class TempMediatorInfoReqDTO implements Serializable {

  private static final long serialVersionUID = 5831190901824788444L;
  private String userName;
  @NotNull(message = "调解员手机号")
  @Size(max = 11, message = "调解员手机号")
  private String mobilePhone;
  private Long userId;

  public TempMediatorInfoReqDTO(Long userId, String userName, String mobilePhone) {
    this.userId = userId;
    this.userName = userName;
    this.mobilePhone = mobilePhone;
  }
}
