package com.beiming.normandy.event.enums;

import com.beiming.normandy.event.dto.MediationCaseProgressDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * @Description: 案件进度枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CaseProgressEnum {
  TRANSFER("已转移"), APPLY("提交申请"), REFUSE("不受理"), WAIT("等待处置"), RETRACT("撤回处置"), START("正在处置"), FAIL(
      "处置失败"), SUCCESS("处置成功"), END("处置结束"),
  
  ABORT("中止");

  private final String name;

  CaseProgressEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  /**
   * 返回包含当前案件状态和案件状态列表
   */
  public static List<MediationCaseProgressDTO> getCaseProgressList(CaseProgressEnum enumObj) {
    List<MediationCaseProgressDTO> lst = new ArrayList<MediationCaseProgressDTO>();
    setCaseProgress(lst, CaseProgressEnum.APPLY, enumObj, 1, false); // 提交申请
    setCaseProgress(lst, CaseProgressEnum.REFUSE, enumObj, 2, true); // 不受理
    setCaseProgress(lst, CaseProgressEnum.WAIT, enumObj, 3, false); // 等待处置
    setCaseProgress(lst, CaseProgressEnum.TRANSFER, enumObj, 4, true); // 已转移
    setCaseProgress(lst, CaseProgressEnum.RETRACT, enumObj, 5, true); // 撤回处置
    setCaseProgress(lst, CaseProgressEnum.START, enumObj, 6, false); // 正在处置
    setCaseProgress(lst, CaseProgressEnum.FAIL, enumObj, 7, true); // 处置失败
    setCaseProgress(lst, CaseProgressEnum.SUCCESS, enumObj, 8, false); // 处置成功
    return lst;
  }

  /**
   * 设置案件进度
   *
   * @param lst 结果列表
   * @param enumX 需要植入的进度状态
   * @param enumY 当前案件进度状态(可NULL)
   * @param order 排序
   * @param hiddenFlag 是否默认隐藏
   */
  private static List<MediationCaseProgressDTO> setCaseProgress(List<MediationCaseProgressDTO> lst,
      CaseProgressEnum enumX, CaseProgressEnum enumY, int order, Boolean hiddenFlag) {
    Boolean flag = false;
    if (enumY != null) {
      flag = enumX.name().equals(enumY.name());
    }
    MediationCaseProgressDTO caseProgressDTO = new MediationCaseProgressDTO(enumX.name(),
        enumX.getName(), (hiddenFlag && flag) ? false : hiddenFlag, flag, order);
    lst.add(caseProgressDTO);
    return lst;
  }
  
  public static Boolean contain(String name) {
    for (CaseProgressEnum caseProgressEnum : CaseProgressEnum.values()) {
      if (caseProgressEnum.name.equals(name)) {
        return true;
      }
    }
    return false;
  }

  /**
   * 华为action转换
   * 
   * @param caseStatus
   * @return
   */
  public static String getCaseStatus(String caseStatus) {
    String action = "report";
    if (Objects.isNull(caseStatus)) {
      return action;
    }
    caseStatus = caseStatus.split("_")[0];
    if (caseStatus.equals(CaseProgressEnum.START.toString())) {
      action = "enforce";
    } else if (caseStatus.equals(CaseProgressEnum.REFUSE.toString())) {
      action = "rejec";
    } else if (caseStatus.equals(CaseProgressEnum.WAIT.toString())) {
      action = "toVerify";
    } else if (caseStatus.equals(CaseProgressEnum.SUCCESS.toString())
        || caseStatus.equals(CaseProgressEnum.END.toString())
        || caseStatus.equals(CaseProgressEnum.FAIL.toString())) {
      action = "end";
    }
    return action;
  }
}
