package com.beiming.normandy.event.enums;

/**
 * 案件类型
 *
 * @author huaisf
 */
public enum CaseTypeEnum {

  /**
   * 普通案件
   */
  NORMAL_CASE("普通案件", "普"),

  /**
   * 简易案件
   */
  SIMPLE_CASE("简易案件", "简"),

  MICRO_CASE("小额速调", "速"),

  LETTER_CASE("信访", "信访"),

  COMPLAINT_CASE("投诉", "投诉"),

  LEGAL_AID_CASE("法律援助", "法律援助"),

  LABOR_ARBITRATION_CASE("劳动仲裁", "劳动仲裁"),

  LABOR_SUPERVISION_CASE("劳动监察", "劳动监察"),

  POLICE_MEDIATION_CASE("警调", "警调"),

  OTHER_APPEAL_CASE("其他诉求", "其他诉求"),

  CIVIL_CASE("民商事纠纷", "民商事纠纷"),

  ADMINISTRATION_CASE("行政争议", "行政争议"),

  JUDICIAL_CONFIRM("司法确认", "司法确认"),

  LAWSUIT("诉讼", "诉讼"),
  ;


  private final String name;

  private final String shortName;

  CaseTypeEnum(String name, String shortName) {
    this.name = name;
    this.shortName = shortName;
  }

  public static String getCaseTypeName(String caseTypeCode) {
    String caseTypeName = "";
    for (CaseTypeEnum e : CaseTypeEnum.values()) {
      if (e.name().equals(caseTypeCode)) {
        caseTypeName = e.getName();
      }
    }
    return caseTypeName;
  }

  public String getName() {
    return name;
  }

  public String getShortName() {
    return shortName;
  }

}
