package com.beiming.normandy.event.enums;

import java.util.Arrays;

/**
 * 新会议预约枚举类（小类型）
 *
 * @author qsh
 * @2018年10月22日
 */
public enum MeetingTypeNewEnum {

  MEETING_ORDER_ONLINE("线上"),
  MEETING_ORDER_OFFLINE("线下"),
  
  MEETING_ORDER_CONSULT("会商"),

  MEETING_RECORD_TELPHONE("记录电话"),
  MEETING_RECORD_SMS("记录短信"),
  MEETING_RECORD_EMAIL("记录邮件"),
  MEETING_RECORD_OTHER("记录其他"),
  
  ;

  private final String name;

  MeetingTypeNewEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static String getString(String key) {

    for (MeetingTypeNewEnum e : MeetingTypeNewEnum.values()) {
      if (e.name().equals(key)) {
        return e.getName();
      }
    }
    return "";

  }


  /**
   * 是否支持文件上传
   * 
   * @param meetingType
   * @return
   */
  public static Boolean isOtherMeetingType(String meetingType) {
    return MeetingTypeNewEnum.MEETING_RECORD_TELPHONE
        .equals(MeetingTypeNewEnum.valueOf(meetingType))
        || MeetingTypeNewEnum.MEETING_RECORD_SMS.equals(MeetingTypeNewEnum.valueOf(meetingType))
        || MeetingTypeNewEnum.MEETING_RECORD_EMAIL.equals(MeetingTypeNewEnum.valueOf(meetingType))
        || MeetingTypeNewEnum.MEETING_RECORD_OTHER.equals(MeetingTypeNewEnum.valueOf(meetingType));
  }

  public static Boolean isOffline(String meetingType) {
    return MeetingTypeNewEnum.MEETING_ORDER_OFFLINE.equals(MeetingTypeNewEnum.valueOf(meetingType));
  }

  /**
   * 根据name()来搜索
   */
  public static MeetingTypeNewEnum getByName(String enumName) {
    return Arrays.stream(MeetingTypeNewEnum.values())
        .filter(switchEnum -> switchEnum.name().equals(enumName))
        .findFirst()
        .orElse(null);
  }
}
