package com.beiming.normandy.event.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.normandy.event.dto.requestdto.ActCalendarListReqDTO;
import com.beiming.normandy.event.dto.requestdto.ActCalendarReqDTO;
import com.beiming.normandy.event.dto.requestdto.OrgStatisticsCountReqDTO;
import com.beiming.normandy.event.dto.responsedto.ActCalendarCountResDTO;
import com.beiming.normandy.event.dto.responsedto.ActCalendarListResDTO;
import com.beiming.normandy.event.dto.responsedto.OrgStatisticsCountResDTO;
import java.util.ArrayList;
import javax.validation.Valid;

/**
 * 行事历接口
 *
 * @author huaisf
 */
@Valid
public interface ActCalendarApi {

  /**
   * 获取调解员行事历每项数量
   */
  DubboResult<ArrayList<ActCalendarCountResDTO>> getCalendarCount(@Valid ActCalendarReqDTO reqDTO);

  /**
   * 调解员行事历详情
   */
  DubboResult<PageInfo<ActCalendarListResDTO>> getCalendarDetails(ActCalendarListReqDTO dto);

  /**
   * 获取机构管理员今日处理情况
   */
  DubboResult<OrgStatisticsCountResDTO> getOrgTodayDealWith(@Valid OrgStatisticsCountReqDTO reqDTO);

  /**
   * 获取机构管理员今日处理情况
   */
  DubboResult<OrgStatisticsCountResDTO> getOrgWaitDealWith(@Valid OrgStatisticsCountReqDTO reqDTO);

  /**
   * 获取机构待办详情
   */
  DubboResult<PageInfo<ActCalendarListResDTO>> getOrgWaitDealWithDetails(ActCalendarListReqDTO dto);


  /**
   * 获取机构待办详情
   */
  DubboResult<ActCalendarCountResDTO> getMediatorCount(ActCalendarReqDTO dto);

}
