package com.beiming.normandy.event.api;

import com.beiming.framework.config.FeignConfig;
import com.beiming.framework.domain.DubboResult;
import com.beiming.normandy.event.dto.responsedto.PersonCaseNumsResDTO;
import java.util.ArrayList;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "normandy-event", path = "/lawCaseKeyPersonApi", configuration = FeignConfig.class, contextId = "LawCaseKeyPersonApi")
public interface LawCaseKeyPersonApi {

  /**
   * 查询案件数超过5件的人（申请人）
   */
  @RequestMapping(value = "selectPersonCaseNums", method = {RequestMethod.POST})
  DubboResult<ArrayList<PersonCaseNumsResDTO>> selectPersonCaseNums(@RequestParam("startTime") String startTime);

}
