package com.beiming.normandy.event.dto;

import com.beiming.framework.page.PageQuery;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 查询调解列表的请求参数(Mapper使用)
 *
 * @author DJQ 2018年7月12日
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class MediationListDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  private String roleType; // 用户角色类型： 纠纷登记员 调解人 普通人
  private Long userId; // 用户ID
  private String userType; // 用户类型（申请人，被申请人，调解人）
  private Long orgId; // 服务机构编号

  private String disputeTypeCode; // 纠纷类型
  private String disputeNo; // 纠纷编号
  private String provCode; // 省份code
  private String cityCode; // 城市code
  private String areaCode; // 区code
  private String streetCode; // 街道code
  private String keyWord; // 关键词 编号、姓名、案号
  private String startTime;
  private String endTime;
  private String mediationType; // 调解类型

  private String transfer; // 是否转移
  private String retract; // 包含撤回
  private List<String> caseStatus; // 案件状态通过progress得到
  private String caseUserTypes; // 案件用户角色(多状态，逗号分隔)

  private Integer status; // 记录状态

  private List<Long> orgIds; // 服务机构列表编号
  private String orgAreaCode; // 机构所在地编号
  private Integer orgAreaCodeLevel; // 机构所在地Level

  private List<Long> excludeOrgIds; // 区域管理员排序的机构编号

  /**
   * 创建者类型逗号分割
   */
  private String creatorType;
  /**
   * from creatorType split
   */
  private List<String> creatorTypes;

  /**
   * 行政行为code
   */
  private String istrativeActCode;

  /**
   * 行政管理主体code
   */
  private String istrativeManageSubjectCode;

  /**
   * 审批情况查询ApprovalSituationEnum
   */
  private List<String> approvalSituation;

  /**
   * 在案件中身份0当事人，1代理人
   */
  private Integer identityType;

  /**
   * 案件类型
   */
  private String caseType;

  /**
   * 案件归属
   */
  private String caseAttribution;

  /**
   * 是否待分配，YES查询待分配
   */
  private String isWaitAssigned;

  /**
   * 排序规则
   */
  Map<String, String> orderConditionMap;

  /**
   * 当前身份对应的案件状态类型mediator_case_status|registrar_case_status|manage_case_status
   */
  private String caseStatusType;
  /**
   * 业务进度状态 字典表中parentCode=caseStatusType remark
   */
  private List<String> bussinessProgresses;

  private boolean isExport;
  
  private Integer docket;
  /**
   * 是否诉求上报列表
   */
  private Boolean isUpReport;
  /**
   * 是否机构协助
   */
  private Boolean isOrgHelp;
  
  private String caseRiskType;
}
