package com.beiming.normandy.event.dto;

import com.beiming.framework.security.JWTContextUtil;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;

@Data
public class OperatorDTO implements Serializable {

  private static final long serialVersionUID = -2627017796488364592L;
  @NotNull(message = "操作人用户ID")
  private Long operatorId;
  @NotNull(message = "操作人用户名称")
  private String operatorName;

  public static OperatorDTO build() {
    OperatorDTO operatorDTO = new OperatorDTO();
    operatorDTO.setOperatorName(JWTContextUtil.getCurrentUserName());
    operatorDTO.setOperatorId(Long.parseLong(JWTContextUtil.getCurrentUserId()));
//    operatorDTO.setOperatorName("SYSTEM");
//    operatorDTO.setOperatorId(1000514L);
    return operatorDTO;
  }

}
