package com.beiming.normandy.event.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 信访代理人案例详情返回
 * @Author: chenjt
 * @Date: Created 2018-10-24
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PetitionAgentDTO implements Serializable {


  private static final long serialVersionUID = 9073193676210757606L;

  /**
   * 信访代理人主键 id
   */
  private Long id;

  /**
   * 信访代理人id
   */
  private Long userId;

  /**
   * 信访代理人姓名
   */
  private String userName;

  /**
   * 信访代理人性别
   */
  private String sex;

  /**
   * 信访代理人联系电话
   */
  private String phone;

  /**
   * 信访代理人身份证号
   */
  private String idCard;

  /**
   * 代理人材料
   */
  private List<MediationAgentMaterialDTO> agentMaterials;

  public PetitionAgentDTO(MediationCasePersonnelDTO dto) {
    this.id = dto.getId();
    this.userId = dto.getUserId();
    this.userName = dto.getName();
    this.sex = dto.getSex();
    this.phone = dto.getPhone();
    this.idCard = dto.getIdCard();
    List<MediationAgentMaterialDTO> agentMaterial = new ArrayList<>();
    for (MediationAgentMaterialDTO mediationAgentMaterialDTO : dto.getAgentMaterials()) {
      agentMaterial.add(new MediationAgentMaterialDTO(mediationAgentMaterialDTO.getAttachmentId(),
          mediationAgentMaterialDTO.getFileId(), null, mediationAgentMaterialDTO.getFileName(), mediationAgentMaterialDTO.getFileType()));
    }
    this.agentMaterials = agentMaterial;
  }

}
