package com.beiming.normandy.event.dto.requestdto;

import com.beiming.framework.util.RegexUtil;
import com.beiming.normandy.basic.api.constants.ValidationMessage;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.Pattern;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class CommonUserIdAndPhoneReqDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  @ApiModelProperty(notes = "用户id", required = true, example = "100012")
  private Long userId;

  @ApiModelProperty(notes = "手机号码", required = true, example = "13800000000")
  @Pattern(regexp = RegexUtil.REGEX_MOBILE_PHONE,
      message = ValidationMessage.MOBILE_PHONE_INCORRECT)
  private String phone;

}
