package com.beiming.normandy.event.dto.requestdto;

import com.beiming.framework.util.RegexUtil;
import com.beiming.normandy.basic.api.constants.ValidationMessage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(description = "配置发送短信公共方法请求入参")
public class ConfigSendSmsRequestDTO implements Serializable {

  private static final long serialVersionUID = 3866080584642267924L;

  @ApiModelProperty(notes = "系统标识", required = true, example = "normandy")
  @NotNull(message = ValidationMessage.SYS_IS_EMPTY)
  private String sys;

  @ApiModelProperty(notes = "手机号码", required = true, example = "13800000000")
  @Pattern(regexp = RegexUtil.REGEX_MOBILE_PHONE,
      message = ValidationMessage.MOBILE_PHONE_INCORRECT)
//  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private String phone;

  @ApiModelProperty(notes = "模板组id集合", required = true, example = "[1,2]")
  @NotNull(message = ValidationMessage.REQUEST_PARAM_IS_NULL)
  private List<Long> templateGroupIds;

  @ApiModelProperty(notes = "案件id", required = false, example = "123")
  private Long caseId;

  @ApiModelProperty(notes = "案件类型", example = "其他诉求")
  private String caseType;

  @ApiModelProperty(notes = "用户id", required = true, example = "100012")
  private Long userId;

  @ApiModelProperty(notes = "文书名称", required = false, example = "调解协议书")
  private String documentName;

  @ApiModelProperty(notes = "业务发起人", required = true, example = "张三")
  private String applicantName;

  @ApiModelProperty(notes = "事件原因", required = false, example = "因XXXX")
  private String reason;

  @ApiModelProperty(notes = "事件其他人员", required = false, example = "")
  private String otherPeople;

  @ApiModelProperty(notes = "事件参与人", required = false)
  private List<CommonUserIdAndPhoneReqDTO> participants;
  
  
  
  @ApiModelProperty(notes = "接受人角色类型，当存在值的时候，需要进行筛选判断")
  private List<String> sendObjectCodeList;

}
