package com.beiming.normandy.event.dto.requestdto;

import java.io.Serializable;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: PC调解室统计参数
 * @Date: Created 2019-02-19 18:02
 */
@Data
@NoArgsConstructor
public class MediationRoomStatisticsReqDTO implements Serializable {


  private static final long serialVersionUID = 44637664179583137L;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 会议类型枚举 会议/调解室 @see com.beiming.odr.referee.enums.MediationMeetingTypeEnum
   */
  private String mediationMeetingType;

  /**
   * 调解室状态
   */
  private String mediationStatus;

  /**
   * 开始时间
   */
  private String startTime;

  /**
   * 结束时间
   */
  private String endTime;

  public MediationRoomStatisticsReqDTO(Long userId, String mediationMeetingType) {
    this.userId = userId;
    this.mediationMeetingType = mediationMeetingType;
  }
}
