package com.beiming.normandy.event.dto.responsedto;

import com.beiming.normandy.event.enums.CaseProgressEnum;
import com.beiming.normandy.event.enums.CaseStatusEnum;
import com.beiming.normandy.event.enums.CaseTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: liufeng
 * @Date: 2021/3/24
 * @desc 案件列表
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
public class CaseListZZResDTO implements Serializable {

  private static final long serialVersionUID = -6736838743439374647L;
  //案件ID
  private Long id;

  //卷宗号
  private String dossierNum;

  //地区
  private String address;

  //卷宗名
  private String dossierName;

  //案件来源
  private String origin;

  //纠纷类型
  private String disputeType;

  //主要争议
  private String disputeContent;

  //数量
  private Integer number;

  //登记日期
  @JsonFormat(pattern = "yyyy-MM-dd")
  private Date createTime;

  //受理日期
  @JsonFormat(pattern = "yyyy-MM-dd")
  private Date startTime;

  //结束时间
  @JsonFormat(pattern = "yyyy-MM-dd")
  private Date endTime;

  //纠纷金额
  private BigDecimal caseAmount;

  //纠纷金额字符串(解决前端显示异常问题)
  private String caseAmountString;

  //赔偿金额
  private BigDecimal compensationAmount;

  //赔偿金额(解决前端显示异常问题)
  private String compensationAmountString;

  //结案日期
  @JsonFormat(pattern = "yyyy-MM-dd")
  private Date caseCompleteTime;

  //调解状态
  private String caseProgress;

  //调解状态枚举
  private CaseProgressEnum caseProgressEnum;

  //调解员
  private String mediatorName;

  //投资者
  private String investor;

  //投资者手机号
  private String investorTelephone;

  //机构ID
  private Long orgId;

  //机构
  private String orgName;

  //案件类型枚举
  private CaseTypeEnum caseTypeEnum;

  //案件類型描述
  private String caseTypeDesc;

  //机构联系方式
  private String orgTelephone;

  //备注
  private String remark;

  //案件小状态枚举
  private CaseStatusEnum lawCaseStatusEnum;

  //案件小状态描述
  private String lawCaseStatus;

  //案件人员信息
  private List<LawCasePersonZZResDTO> casePerson;
  /**
   * 案件编号
   */
  private String caseNo;
  /**
   * 案件来源
   */
  private String creatorType;
  /**
   * 案件来源中文名
   */
  private String creatorTypeName;

}
