package com.beiming.normandy.event.dto.responsedto;

import com.beiming.framework.util.Date2LongSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 调解记录实体类
 *
 * @author qsh
 * @data 2018年6月29日
 */
@Data
public class CaseMeetingListResDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  private Long id;
  private Long lawCaseId; // 案件id
  private Long orderTemplateId; // 预约模板id
  private String meetingType; // 会议类型
  private String meetingTypeName; // 会议类型中文
  private String meetingStatus; // 会议状态 NOT_END：未结束END结束,会议进行中：UNDERWAY
  private String meetingContent; // 会议内容
  private String orderType; // 预约类型 0:online 1:offline
  private String inviteCode; // 观摩人的邀请码
  private String joinUserId; // 参与者id
  private String meetingVideoId; // 视频服务id
  private String joinUserName; // 参与者
  private String meetingName; // 会议名称
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date createTime;
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date orderTime; // 预约会议
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date endTime; // 会议结束时间
  private String startDaily; // 开启日志

  private boolean cancelMeetingFlag; // 取消预约标识
  private boolean mediateDailyFlag; // 调解日志标识
}
