package com.beiming.normandy.event.enums;

import lombok.extern.slf4j.Slf4j;

/**
 * @Description: 书证类型枚举
 * @Author: caiwei
 * @Date: Created 2018-06-26
 */
@Slf4j
public enum DocumentEvidenceTypeEnum {

  /**
   * 卷宗
   */
  LAW_CASE_DOSSIER_COVER("卷宗封面"),
  LAW_CASE_DOSSIER_CATALOG("卷宗目录"),
  LAW_CASE_DOSSIER_BACKCOVER("卷宗封底"),
  
  /**
   * 身份证证明下资料名称
   */
  AUTHORIZE_PROXY("授权委托书"), 
  PARTY_IDENTIFICATION_PAPER("当事人身份证明"), 
  AGENT_IDENTIFICATION_PAPER("代理人身份证明"),
  /**
   * 文书材料
   */
  MEDIATION_APPLY_BOOK("调解申请书"), 
  PARTY_DROIT_NOTIFY_BOOK("当事人权利义务告知书"),
  MEDIATION_RECORD("调解笔录"), 
  INQUIRE_RECORD("调查笔录"), 
  MEDIATION_BOOK("调解协议书"), 
  MEDIATION_AGREEMENT_PERFORM_PROVE("调解协议履行证明"), 
  JUDICIAL_CONFIRM_APPLY_BOOK("司法确认申请书"), 
  DEFAULT_FILE("默认附件"), 
  MEDIATION_VIST_RECORD("调解回访记录"), 
  MEDIATION_EVIDENCE_MATERIAL("调解证据材料"), 
  COMMITMENT_BOOK("承诺书"), 
  NO_DISSENT_MEDIATION_SCHEME("无异议调解方案"), 
  UNDISPUTED_FACT("无争议事实"), 
  DISSENT_RECORD("异议书"), 
  EVIDENCE_INVENTORY("证据清单"), 
  PETITION_AGENT_AUTHORIZE_PROXY("信访授权委托书"), 
  GENERAL_AGENT_AUTHORIZE_PROXY("一般代理人授权委托书"), 
  PRIVILEGED_AGENT_AUTHORIZE_PROXY("特权代理人授权委托书"),
//  AGENT_AUTHORIZE_PROXY("授权委托书"),
  RELATIONSHIP_REFERENCE("关系证明文件"),
  MADIATION_PROGERSS("调解进度"), 
  PEOPLE_MEDIATION_ORAL_AGREEMENT("人民调解口头协议书"), 
  DOC_ADDRESS_BOOK("送达地址确认书"), 
  OTHER("其他"), 
  SETTLE_CASE_TABLE("结案表"),
  DELEGATE_MEDIATION_NOTICE_BOOK("委派调解告知书"),
  AUTHORIZE_MEDIATION_NOTICE_BOOK("委托调解告知书"),
  RIGHTS_AND_OBLIGATIONS_NOTICE_BOOK("调解当事人权利义务告知书"), //用户不需要签名
  END_MEDIATION_REPORT("终结调解报告")
  ;

  private final String name;

  /**
   *
   */
  DocumentEvidenceTypeEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }
  
  /**
   * 判断是否为身份关系材料
   * @param e
   * @return
   */
  public static Boolean isRelationMaterial(String e) {
    return GENERAL_AGENT_AUTHORIZE_PROXY.name().equals(e)
        || PRIVILEGED_AGENT_AUTHORIZE_PROXY.name().equals(e)
        || RELATIONSHIP_REFERENCE.name().equals(e);
  }

  public static String getNameByString(String name) {
    String result = null;
    try {
      result = DocumentEvidenceTypeEnum.valueOf(name).getName();
    } catch (Exception e) {
      log.error("DocumentEvidenceTypeEnum getNameByString {}", name, e);
    }
    return result;
  }
}
