package com.beiming.normandy.event.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public enum WitnessTypeEnum {

  REALNESS("真实性"), LEGALITY("合法性"), RELEVANCY("关联性"), OTHER("其他");
  private String desc;

  WitnessTypeEnum(String desc) {
    this.desc = desc;
  }

  public String getdesc() {
    return desc;
  }

  public static String getDesc(String name) {
    for (WitnessTypeEnum enumm : WitnessTypeEnum.values()) {
      if (name.equals(enumm.name())) {
        return enumm.getdesc();
      }
    }
    return null;
  }

  public static JSONArray toJsonArray() {
    JSONArray array = new JSONArray();
    JSONObject obj = null;
    for (WitnessTypeEnum enumm : WitnessTypeEnum.values()) {
      obj = new JSONObject();
      obj.put("code", enumm.name());
      obj.put("desc", enumm.getdesc());
      array.add(obj);
    }
    return array;
  }

  public static void main(String[] args) {
    WitnessTypeEnum.toJsonArray();
  }
}
