package com.beiming.normandy.event.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.domain.ResultCode;
import com.beiming.normandy.event.constant.RefereeValidateMessage;
import com.beiming.normandy.event.dto.MediationCasePersonnelDTO;
import com.beiming.normandy.event.dto.PersonnelInfoDTO;
import com.beiming.normandy.event.dto.requestdto.CasePersonReqDTO;
import com.beiming.normandy.event.dto.requestdto.CommonIdReqDTO;
import com.beiming.normandy.event.dto.requestdto.OperatorReqDTO;
import com.beiming.normandy.event.dto.requestdto.UserIdListReqDTO;
import com.beiming.normandy.event.dto.responsedto.CaseProtocolPersonnelResDTO;
import com.beiming.normandy.event.enums.CasePersonAuthorityEnum;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;


/**
 * 案件人员api
 *
 * @author xzy
 * @data 2018年9月25日
 */
@Valid
public interface LawCasePersonnelApi {

  /**
   * 通过案件id查询案件人员
   */
  DubboResult<ArrayList<CaseProtocolPersonnelResDTO>> getPersonList(@Valid @NotNull(
      message = RefereeValidateMessage.PARAMETER_IS_NULL) Long caseId);

  /**
   * 通过案件id查询案件人员
   */
  DubboResult<ArrayList<MediationCasePersonnelDTO>> getPersonList(@Valid CasePersonReqDTO dto);

  /**
   * 判断当前用户是否有上传调解材料的权限
   *
   * @param userId 用户id
   * @param caseId 案件id
   */
  String checkUpload(
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_USER_ID_NULL) Long userId,
      @Valid @NotNull(message = RefereeValidateMessage.PARAMETER_CASE_ID_NULL) Long caseId);

  /**
   * 邀请协助调解员
   *
   * @param reqDTO 邀请人员列表
   * @param operator 操作人
   */
  DubboResult inviteMediatorHelp(@Valid UserIdListReqDTO reqDTO, OperatorReqDTO operator);

  /**
   * 根据案件id查案号
   */
  DubboResult<MediationCasePersonnelDTO> findLawCaseById(Long lawCaseId);


  /**
   * 获取申请重新分配调解员
   */
  DubboResult<MediationCasePersonnelDTO> getMediatorByRedistribution(CommonIdReqDTO requestDTO);

  void authorityCheck(Long userId, ArrayList<CaseProtocolPersonnelResDTO> data,
      CasePersonAuthorityEnum casePersonAuthorityEnum, ResultCode resultCode, String message);

  void authorityCheckByUserId(Long lawCaseId, Long userId,
      CasePersonAuthorityEnum casePersonAuthorityEnum, ResultCode resultCode, String message);

  /**
   * 获取协助调解员列表
   *
   * @param caseId 案件id
   */
  List<PersonnelInfoDTO> getMediatorHelpList(Long caseId);
}
