package com.beiming.normandy.event.api;


import com.beiming.framework.domain.DubboResult;
import com.beiming.normandy.event.dto.requestdto.MediationCaseDraftDelReqDTO;
import com.beiming.normandy.event.dto.requestdto.MediationCaseReqDTO;
import com.beiming.normandy.event.dto.responsedto.CaseNumResDTO;
import javax.validation.Valid;

/**
 * @Description: 调解案件草稿api接口
 * @Author: chenjt
 * @Date: Created 2018-11-29
 */
@Valid
public interface MediationCaseDraftApi {
  /**
   * 保存草稿案件
   */
  DubboResult<Long> saveMediationCaseDraft(@Valid MediationCaseReqDTO mediationCaseReqDTO);

  /**
   * 删除草稿案件
   */
  DubboResult deleteMediationCaseDraft(@Valid MediationCaseDraftDelReqDTO reqDTO);

  /**
   * 查询纠纷登记员创建的案件数量
   */
  DubboResult<CaseNumResDTO> queryCaseNumByCreatorId(@Valid Long creatorId);

}
