package com.beiming.normandy.event.dto;

import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class LawCaseInfoDTO {

  private static final long serialVersionUID = -5237937142037969185L;

  private Long id;
  /**
   * 调解类型(人民调解，行政调解)
   */
  private String mediationType;

  /**
   * 案件录入人id
   */
  private Long creatorId;

  /**
   * 案件录入人的身份
   */
  private String creatorType;

  /**
   * 案件编号
   */
  private String caseNo;

  /**
   * 系统案件编号，存放受理前案号
   */
  private String sysCaseNo;

  /**
   * 视频表id
   */
  private Long videoId;

  /**
   * 状态码(05纠纷被拒绝受理等)
   */
  private String lawCaseStatus;

  /**
   * 案件进度
   */
  private String caseProgress;

  /**
   * 咨询纠纷id，咨询转立案存入该值
   */
  private Long disputesId;

  /**
   * 纠纷类型字典表code
   */
  private String disputeTypeCode;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 省code
   */
  private String provCode;

  /**
   * 市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 省名称
   */
  private String provName;

  /**
   * 市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 详细地址
   */
  private String address;

  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 机构地区code
   */
  private String orgAreaCode;

  /**
   * 调解员名称， 多个调解员中文逗号隔开
   */
  private String mediatorName;

  /**
   * 案件来源。本平台录入； 第三方平台导入。网上立案系统导入，律师平台导入
   */
  private String origin;

  /**
   * 调解开始时间
   */
  private Date startTime;

  /**
   * 调解结束时间
   */
  private Date endTime;

  /**
   * 案件完成时间
   */
  private Date caseCompleteTime;

  /**
   * 重新分配的标签
   */
  private String tab;

  /**
   * 选择性短信发送功能 0为发送，1为不发送
   */
  private Integer smsOff;

  /**
   * 社区code
   */
  private String communityCode;

  /**
   * 社区名称
   */
  private String communityName;

  /**
   * 是否立案标识
   */
  private Boolean docket;

  /**
   * 诉讼/司法编号
   */
  private String suitNo;

  /**
   * 纠纷难易程度code
   */
  private String difficultyDisputeCode;

  /**
   * 纠纷难易程度名称
   */
  private String difficultyDisputeName;

  /**
   * 行政行为code
   */
  private String istrativeActCode;

  /**
   * 行政管理主体code
   */
  private String istrativeManageSubjectCode;

  /**
   * 是否行政赔偿0否1是
   */
  private Integer isCompensation;

  /**
   * 行政管理具体code
   */
  private String istrativeManageSpecificCode;

  /**
   * ApprovalSituationEnum,审批情况
   */
  private String approvalSituation;

  /**
   * 行政管理主体名称
   */
  private String istrativeManageSubjectName;

  /**
   * 行政管理具体名称
   */
  private String istrativeManageSpecificName;

  /**
   * 行政行为名称
   */
  private String istrativeActName;

  /**
   * 普通案件：NORMAL_CASE，简易案件：SIMPLE_CASE
   */
  private String caseType;

  /**
   * 案件归属
   */
  private String caseAttribution;

  /**
   * 第三方系统编号
   */
  private String thirdCaseNo;

  /**
   * 案件同步到哪一个第三方
   */
  private String syncThird;

  /**
   * 纠纷描述
   */
  private String disputeContent;

  /**
   * 重新分配的详细内容
   */
  private String tabDetail;

  /**
   * 申请人诉求
   */
  private String appeal;

  /**
   * 案件其他信息
   */
  private String handlingInfo;


}
