package com.beiming.normandy.event.dto.requestdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 矛盾纠纷报表请求参数
 */
@Data
@ApiModel(description = "获取矛盾纠纷状态统计请求参数")
public class ConflictStatusAnalysisRequestDTO implements Serializable {

  @ApiModelProperty(notes = "统计日期", required = true, example = "2019-03-29")
  @NotNull(message = "统计日期不能为空")
  private String statsDate;

  @ApiModelProperty(notes = "统计维度", example = "ORGANIZATION MEDIATOR")
  @NotNull(message = "统计维度不能为空")
  private String statisticalDimension;

  @ApiModelProperty(notes = "维度的对应值", example = "100563")
  @NotNull(message = "机构或调解员id不能为空")
  private String paramName;

  @ApiModelProperty(notes = "维度的对应的中文名", example = "调解中心1")
  @NotNull(message = "机构或调解员姓名不能为空")
  private String paramValue;
}
