package com.beiming.normandy.event.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import com.beiming.normandy.event.dto.CaseUserAgentDTO;
import com.beiming.normandy.event.enums.RegisterOriginEnum;
import lombok.Data;

/**
 * @Description: 录入调解案件用户信息
 * @Author: caiwei
 * @Date: Created 2018-06-27
 */
@Data
public class MediationCaseUserReqDTO implements Serializable {

  private static final long serialVersionUID = 525392647113077587L;

  // id
  private Long id;

  // 案件id
  private Long caseId;

  // 用户id
  private Long userId;

  // 案件用户类型
  private String caseUserType;

  // 用户类型
  private String userType;

  // 名称
  private String name;

  // 性别
  private String sex;

  // 联系电话
  private String phone;

  // 固定电话
  private String telephone;

  // 身份证号
  private String idCard;

  // 省份code
  private String provCode;

  // 城市code
  private String cityCode;

  // 区code
  private String areaCode;

  // 街道code
  private String streetCode;

  // 省份名称
  private String provName;

  // 城市名称
  private String cityName;

  // 区名称
  private String areaName;

  // 街道名称
  private String streetName;

  // 详细地址
  private String address;

  // 信用代码
  private String creditCode;

  // 法人代表
  private String corporation;

  // 代理人id
  private Long agentId;

  private String agentTypeParent;

  //代理人类型
  private String agentType;

  //与当事人关系
  private String relationshipWithParties;

  // 代理人委托书来源
  private String origin;


  //代理用户信息
  private List<CaseUserAgentDTO> caseUserAgentList;


  // 排序
  private Integer order;


  // 用户注册来源(REGISTER_SELF: 用户自己注册  REGISTER_PLATFORM: 平台自动注册)
  private RegisterOriginEnum userRegisterOrigin;

  // 创建者
  private String createUser;

  // 更新者
  private String updateUser;
  /**
   * 送达文书确认书
   */
  private String docAddress;

  /**
   * 其它联系电话
   */
  private String contactPhone;
  /**
   * 联系方式类型 字典表中contact_type的子集
   */
  private String contactType;
  
  /**
   * 其它证件类型（律师证）
   */
  private String certificateType;

  /**
   * 其它证件号
   */
  private String certificateNo;
  
  /**
   * 扩展json串
   */
  private String extendJson;
}
