package com.beiming.normandy.event.dto.requestdto.dispute;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 客服转接咨询师
 * @Date: Created 2018-07-08 8:56
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ChangeToCounselorReqDTO implements Serializable {

  private static final long serialVersionUID = -2501838170764078939L;

  @NotNull(message = "纠纷ID不可空")
  @Min(value = 1l, message = "值非法")
  private Long id;

  @NotNull(message = "客服ID不可为空")
  @Min(value = 1l, message = "值非法")
  private Long customerId;

}
