package com.beiming.normandy.event.dto.responsedto;

import com.beiming.framework.util.Date2LongSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class CaseMeetingVideoResDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  private String joinUser;
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date uploadTime;
  private String download;
  private String preview;
  private String userType;


  public CaseMeetingVideoResDTO caseMeetingVideoResCoversion(String playUrl, Long startTime,
      String joinUser, String memberType) {
    CaseMeetingVideoResDTO caseMeetingVideoResDTO = new CaseMeetingVideoResDTO();
    caseMeetingVideoResDTO.setDownload(playUrl);
    caseMeetingVideoResDTO.setJoinUser(joinUser);
    caseMeetingVideoResDTO.setPreview(playUrl);
    caseMeetingVideoResDTO.setUploadTime(new Date(startTime));
    caseMeetingVideoResDTO.setUserType(memberType);
    return caseMeetingVideoResDTO;
  }

}
