package com.beiming.normandy.event.dto.responsedto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "矛盾纠纷状态统计分析收案")
public class ConflictCaseApplyResponseDTO implements Serializable {

  private static final long serialVersionUID = 66476012171229392L;

  @ApiModelProperty(notes = "总案件数", example = "200")
  private Integer allCaseCount;

  @ApiModelProperty(notes = "自主登记数", example = "100")
  private Integer commonCaseCount;

  @ApiModelProperty(notes = "工作人员登记数", example = "50")
  private Integer workCaseCount;

  @ApiModelProperty(notes = "未受理数（刚提交的案件数）", example = "200")
  private Integer caseApplyCount;

  @ApiModelProperty(notes = "受理数（总案件数-未受理数）", example = "200")
  private Integer caseAcceptCount;
}