package com.beiming.normandy.event.enums;

import java.util.Arrays;
import java.util.List;

/**
 * @Description: 案件用户类型
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CaseUserTypeEnum {

  APPLICANT("申请人", "申"),
  RESPONDENT("被申请人", "被"),
  APPLICANT_AGENT("申请人代理人", "申代"),
  RESPONDENT_AGENT("被申请人代理人", "被代"),
  MEDIATOR("调解员", ""),
  ORG_MANAGE("机构管理员", ""),
  
  APP_LITIGANT_AGENT("申请人法定代表人", ""),
  RES_LITIGANT_AGENT("被申请人法定代表人", ""),
  
  APPLICANT_AGENT_GENERAL("申请人一般代理人", ""),
  APPLICANT_AGENT_PRIVILEGED("申请人特权代理人", ""),
  APPLICANT_AGENT_JUVENILES("申请人特权代理人", ""),
  APPLICANT_AGENT_PSYCHOTIC("申请人特权代理人", ""),
  RESPONDENT_AGENT_GENERAL("被申请人一般代理人", ""),
  RESPONDENT_AGENT_PRIVILEGED("被申请人特权代理人", ""),
  RESPONDENT_AGENT_JUVENILES("被申请人特权代理人", ""),
  RESPONDENT_AGENT_PSYCHOTIC("被申请人特权代理人", ""),

  PETITION_AGENT("信访代理人", ""), 
  GENERAL_AGENT("一般代理人", ""), 
  PRIVILEGE_AGENT("特权代理人", ""), 
  JUVENILES("未成年人", ""),
  PSYCHOTIC("无民事行为能力、限制民事行为能力的精神病人", ""),

  MEDIATOR_HELP("协助调解员", ""), 
  MEDIATOR_HELP_TEMPORARY("临时协助调解员", ""),
  LITIGANT("当事人", "?"),
  ARBITRATOR("仲裁员", ""), 
  SECRETARY("办案秘书", ""),
  CLERK("书记员", "书记员"),
  RECORDER("记录人员", ""),
  APPLY_CASE("立案员", ""),
  JUROR("陪审员", "陪审员"),
  JUDGE("法官", "法官"),
  LINESMAN("边裁", ""),
  ASSISTANT_JUDGE("法官助理", "法助"),
  LITIGANT_WITNESS("证人", "证人"),
  LITIGANT_THIRD("第三人", "第三人"),
  // 只对会议用
  INVITATION_WATCHER("观摩人", ""), // 有权限;
  INVITATION_WATCHER_NO_PICTURE("观摩人无画面", ""),

  PARTICIPANTS("参与人", ""),
  
  APPLICANT_SIDE("申请方", ""),
  RESPONDENT_SIDE("被申请方", ""),
  ;


  private final String name;
  private final String desc;
 

  CaseUserTypeEnum(String name, String desc) {
    this.name = name;
    this.desc = desc;
  }

  public String getName() {
    return name;
  }

  public String getDesc() {
    return desc;
  }

  /**
   * 获取代理人所代理的当事人类型
   * 
   * @param e
   * @return
   */
//  public static String getClientType(String e) {
//    if (APPLICANT_AGENT.name().equals(e)) {
//      e = APPLICANT.name();
//    }
//    if (RESPONDENT_AGENT.name().equals(e)) {
//      e = RESPONDENT.name();
//    }
//    // TODO 特权代理人类型确认?
//    return e;
//  }

  /**
   * 获取当事人的代理人类型
   *
   * @param e
   * @return
   */
//  public static String getAgentType(String e) {
//    if (APPLICANT.name().equals(e)) {
//      e = APPLICANT_AGENT.name();
//    }
//    if (RESPONDENT.name().equals(e)) {
//      e = RESPONDENT_AGENT.name();
//    }
//    return e;
//  }

  /**
   * 判断是否为当事人类型(LITIGANT)
   * 
   * @param e
   * @return
   */
//  public static Boolean isLitigant(String e) {
//    return LITIGANT.name().equals(e);
//  }

  /**
   * 判断是否为当事人类型(APPLICANT,RESPONDENT)
   * 
   * @param e
   * @return
   */
  public static Boolean isClient(String e) {
    return APPLICANT.name().equals(e) || RESPONDENT.name().equals(e);
  }
  
  /**
   * 判断是否为申请方(APPLICANT,APPLICANT_AGENT)
   * 
   * @param e
   * @return
   */
  public static Boolean isApplicant(String e) {
    return APPLICANT.name().equals(e) || APPLICANT_AGENT.name().equals(e);
  }

  /**
   * 是否是被申请方
   */
  public static boolean isRespondent(String userType) {
    return CaseUserTypeEnum.RESPONDENT.name().equals(userType)
        || CaseUserTypeEnum.RESPONDENT_AGENT.name().equals(userType);
  }

  /**
   * 是否是调解员
   */
  public static boolean isMediator(String userType) {
    return CaseUserTypeEnum.MEDIATOR.name().equals(userType);
  }

  /**
   * 判断是否是协助调解员
   */
  public static boolean isMediatorHelp(String userType) {
    return CaseUserTypeEnum.MEDIATOR_HELP.name().equals(userType);
  }
  public static boolean isMediatorOrHelp(String userType) {
    return isMediator(userType) || isMediatorHelp(userType);
  }

  public static Boolean isAgent(String caseUserType) {
    return caseUserType.endsWith("_AGENT");
  }

  public static Boolean isLitigantUser(String meetingUserType) {
    return LITIGANT.name().equalsIgnoreCase(meetingUserType)
        || APPLICANT.name().equalsIgnoreCase(meetingUserType)
        || RESPONDENT.name().equalsIgnoreCase(meetingUserType)
        || APPLICANT_AGENT.name().equalsIgnoreCase(meetingUserType)
        || RESPONDENT_AGENT.name().equalsIgnoreCase(meetingUserType)
        || LITIGANT_WITNESS.name().equalsIgnoreCase(meetingUserType)
        || LITIGANT_THIRD.name().equalsIgnoreCase(meetingUserType);
  }
  
  public static Boolean isMediatorUser(String meetingUserType) {
    return MEDIATOR.name().equalsIgnoreCase(meetingUserType)
        || MEDIATOR_HELP.name().equalsIgnoreCase(meetingUserType)
        || MEDIATOR_HELP_TEMPORARY.name().equalsIgnoreCase(meetingUserType)
        || JUDGE.name().equalsIgnoreCase(meetingUserType)
        || ASSISTANT_JUDGE.name().equalsIgnoreCase(meetingUserType)
        || CLERK.name().equalsIgnoreCase(meetingUserType)
        || JUROR.name().equalsIgnoreCase(meetingUserType);
  }

  public static Boolean isMeetingMediatorUser(String meetingUserType) {
    return MEDIATOR.name().equalsIgnoreCase(meetingUserType)
        || JUDGE.name().equalsIgnoreCase(meetingUserType)
        || ASSISTANT_JUDGE.name().equalsIgnoreCase(meetingUserType)
        || CLERK.name().equalsIgnoreCase(meetingUserType)
        || JUROR.name().equalsIgnoreCase(meetingUserType);
  }

  public static CaseUserTypeEnum getCaseUserType(String caseUserType) {
    return Arrays.stream(CaseUserTypeEnum.values())
        .filter(switchEnum -> switchEnum.toString().equals(caseUserType)).findFirst().orElse(null);
  }

  public static List<String> getMediatorUserEnumName() {
    return Arrays.asList(MEDIATOR.name(), JUDGE.name(), ASSISTANT_JUDGE.name(), CLERK.name(), JUROR.name());
  }
  
  public static List<String> getSizeName() {
    return Arrays.asList(APPLICANT_SIDE.name(), RESPONDENT_SIDE.name());
  }
  
  
  public static Boolean isEvaluate(String meetingUserType) { // 当事人评价
    return APPLICANT.name().equalsIgnoreCase(meetingUserType)
        || RESPONDENT.name().equalsIgnoreCase(meetingUserType)
        || APPLICANT_AGENT.name().equalsIgnoreCase(meetingUserType)
        || RESPONDENT_AGENT.name().equalsIgnoreCase(meetingUserType)
        || APP_LITIGANT_AGENT.name().equalsIgnoreCase(meetingUserType)
        || RES_LITIGANT_AGENT.name().equalsIgnoreCase(meetingUserType);
  }
}
