package com.beiming.normandy.event.enums;

/**
 * 进度类型 案件进度，卷宗进度，诉讼进度
 *
 * @author qsh
 * @data 2018年6月29日
 */
public enum SubjectTypeEnum {
  /**
   * 卷宗进度类型
   */
  DOSSIER_TYPE("dossier", null),
  /**
   * 案件进度类型
   */
  LAW_CASE_TYPE("law_case", null),
  BUTTON("按钮生成的进度", LAW_CASE_TYPE),

  FLOW("流程生成的进度", LAW_CASE_TYPE),
  /**
   * 会议进度类型
   */
  MEETING_TYPE("meeting", null),
  /**
   * 诉讼进度类型
   */
  LAW_SUIT_TYPE("law_suit", null),
  /**
   * 卷宗封面，封底，卷内目录，不在前端显示
   */
  DOSSIER_WORD("dossier_word", null),
  /**
   * 鉴定进度类型
   */
  APPRAISAL_TYPE("appraisal", null),

  /**
   * 评估类型
   */
  EVALUATION_TYPE("evaluation", null);

  private final String name;
  
  private final SubjectTypeEnum parent;

  /**
   *
   */
  SubjectTypeEnum(String name, SubjectTypeEnum parent) {
    this.name = name;
    this.parent = parent;
  }

  public String getName() {
    return name;
  }

}
