package com.beiming.normandy.event.api;

import com.beiming.framework.config.FeignConfig;
import com.beiming.framework.domain.DubboResult;
import com.beiming.normandy.event.dto.requestdto.ConflictAnalysisReqDTO;
import com.beiming.normandy.event.dto.requestdto.ConflictStatusAnalysisRequestDTO;
import com.beiming.normandy.event.dto.requestdto.EventAnalysisRequestDTO;
import com.beiming.normandy.event.dto.requestdto.PlatformOverviewReqDTO;
import com.beiming.normandy.event.dto.responsedto.CaseAnalysisResponseDTO;
import com.beiming.normandy.event.dto.responsedto.CaseHandleResponseDTO;
import com.beiming.normandy.event.dto.responsedto.ConflictStatsTotalResponseDTO;
import com.beiming.normandy.event.dto.responsedto.ConflictStatusAnalysisResponseDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author czt94 新乡行政区域管理员-统计矛盾纠纷相关报表
 */
@FeignClient(value = "normandy-event", path = "/lawCaseReportApi", configuration = FeignConfig.class, contextId = "LawCaseReportApi")
public interface LawCaseReportApi {

  /**
   * 矛盾纠纷分析：获取案件办理情况数据（折线图）
   *
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "getCaseHandleData", method = RequestMethod.POST)
  DubboResult<ArrayList<CaseHandleResponseDTO>> getCaseHandleData(@RequestBody @Valid
      ConflictAnalysisReqDTO reqDTO);

  /**
   * 矛盾纠纷分析：案件概览
   *
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "getStatsTotal", method = RequestMethod.POST)
  DubboResult<ConflictStatsTotalResponseDTO> getStatsTotal(@RequestBody @Valid
      ConflictAnalysisReqDTO reqDTO);

  /**
   * 矛盾纠纷报表（根据机构和调解员维度查询案件数据）
   *
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "getStatusAnalysis", method = RequestMethod.POST)
  DubboResult<ArrayList<ConflictStatusAnalysisResponseDTO>> getStatusAnalysis(@RequestBody @Valid
      ConflictStatusAnalysisRequestDTO reqDTO);

  /**
   * 平台概览：案件数据
   *
   * @param reqDTO
   * @return
   */
  @RequestMapping(value = "getCaseCount4Org", method = RequestMethod.POST)
  DubboResult<Integer> getCaseCount4Org(@RequestBody @Valid PlatformOverviewReqDTO reqDTO);

  /**
   * 获取案件分析结果（给孚立系统提供）
   *
   * @param requestDTO
   * @return
   */
  List<CaseAnalysisResponseDTO> getCaseAnalysisData(EventAnalysisRequestDTO requestDTO);
}
