package com.beiming.normandy.event.dto;

import com.beiming.normandy.event.enums.DocumentEvidenceTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class MediationAgentMaterialDTO implements Serializable {
  
  private static final long serialVersionUID = 1L;
  
  private Long attachmentId;

  @ApiModelProperty(notes = "文件id", example = "aGViZWlvZHJfMjBmZTgyNTdjZTkxNDc0MzgwZTlmOGY1ZTZlMmM4ODY=.png")
  private String fileId;

  @ApiModelProperty(notes = "文件路径")
  private String path;

  @ApiModelProperty(notes = "文件名称", example = "授权委托书.pdf")
  private String fileName;

  @ApiModelProperty(notes = "文件类型：当代理人类型选择委托代理人时传授权委托书（AGENT_AUTHORIZE_PROXY），限一份;"
      + "当代理人类型是法定/指定代理人时传关系证明文件（RELATIONSHIP_REFERENCE），限五份; 两种文书只存在一种", example = "AGENT_AUTHORIZE_PROXY")
  private DocumentEvidenceTypeEnum fileType;

  public MediationAgentMaterialDTO(Long attachmentId, String fileId, String fileName,
      DocumentEvidenceTypeEnum fileType) {
    this.attachmentId = attachmentId;
    this.fileId = fileId;
    this.fileName = fileName;
    this.fileType = fileType;
  }
}
