package com.beiming.normandy.event.dto.requestdto;

import com.beiming.normandy.event.enums.StatisticPeriodEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@ApiModel(description = "矛盾纠纷统计分析请求参数")
@NoArgsConstructor
@AllArgsConstructor
public class ConflictAnalysisReqDTO implements Serializable {

  private static final long serialVersionUID = -2078279178909557240L;

  @ApiModelProperty(notes = "统计日期", required = true, example = "2019-03-29")
  @NotNull(message = "统计日期不能为空")
  private String statsDate;

  @ApiModelProperty(notes = "机构id", example = "1")
  @NotNull(message = "机构id不能为空")
  private Long orgId;

  @ApiModelProperty(notes = "调解员id", example = "1")
  private Long mediatorId;

  @ApiModelProperty(notes = "统计粒度(案件办理情况需传值)")
  private StatisticPeriodEnum statisticPeriod;
}
