package com.beiming.normandy.event.dto.requestdto;

import com.beiming.framework.page.PageQuery;
import java.io.Serializable;
import lombok.Data;

/**
 * @author dongjunqing
 * @ClassName MediationRoomListReqDTO
 * @Description 调解室列表
 * @date Mar 10, 2020 3:40:02 PM
 */
@Data
public class MediationRoomListReqDTO extends PageQuery implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * 视频状态
   */
  private String mediationStatus;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 会议类型
   */
  private String mediationMeetingType;

  /**
   * 视频名字或者姓名模糊
   */
  private String keyword;

  /**
   * 开始时间(yyyy-MM-dd HH:mm:ss)
   */
  private String startTime;

  /**
   * 结束时间(yyyy-MM-dd HH:mm:ss)
   */
  private String endTime;

}
