package com.beiming.normandy.event.dto.requestdto.dispute;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by chenjt on 2018/6/27
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputeLawCaseReqDTO implements Serializable {


  private static final long serialVersionUID = -3223177834763421930L;

  public DisputeLawCaseReqDTO(Long lawCaseId, Long disputeId) {
    this.lawCaseId = lawCaseId;
    this.disputeId = disputeId;
  }
  /**
   * 纠纷id
   */
  @NotNull(message = "纠纷ID不可为空")
  @Min(value = 1l, message = "值非法")
  private Long disputeId;

  /**
   * 案件id
   */
  @NotNull(message = "案件id不可为空")
  private Long lawCaseId;

  /**
   * 记录更新案件ID的用户id
   */
  //@NotNull(message = "用户id不可为空")
  private Long userId;

}
