package com.beiming.normandy.event.dto.requestdto.dispute;

import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description:
 * @Date: Created 2018-07-10 16:37
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputesChatWinReqDTO implements Serializable {

  public DisputesChatWinReqDTO(Long id, String userId) {
    this.id = id;
    this.userId = userId;
  }

  /**
   * 纠纷id
   */
  @NotNull(message = "纠纷ID不可为空")
  @Min(value = 1l, message = "值非法")
  private Long id;

  @NotBlank(message = "用户ID不可为空")
  private String userId;

  //@NotNull(message = "用户名称不可为空")
  private String userName;

  //@NotNull(message = "用户角色列表不可为空")
  private List<String> roleList;

  //@NotBlank(message = "聊天室id")
  private String roomId;



}
