package com.beiming.normandy.event.dto.responsedto;

import com.beiming.normandy.event.dto.MediationCasePersonnelDTO;
import com.beiming.normandy.event.enums.RegisterOriginEnum;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description: 协议相关人返回实体
 * @Author: caiwei
 * @Date: Created 2018-06-30
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class CaseProtocolPersonnelResDTO implements Serializable {

  private static final long serialVersionUID = -4866238168967161027L;
  //案件id
  private Long lawCaseId;
  // 人员id
  private Long personnelId;

  // 文书id
  private Long documentId;

  // 案件用户类型
  private String caseUserType;

  // 用户ID
  private Long userId;

  // 用户类型
  private String userType;

  // 名称
  private String userName;

  // 性别
  private String sex;

  // 电话
  private String phone;

  // 身份证号
  private String idCard;

  // 省份code
  private String provCode;

  // 城市code
  private String cityCode;

  // 区code
  private String areaCode;

  // 街道code
  private String streetCode;

  // 省份名称
  private String provName;

  // 城市名称
  private String cityName;

  // 区名称
  private String areaName;

  // 街道名称
  private String streetName;

  // 详细地址
  private String address;

  // 信用代码
  private String creditCode;

  // 法人代表
  private String corporation;


  // 排序
  private Integer userOrder;
  /**
   * 送达地址确认书
   */
  private String docAddress;
  /**
   * 材料id
   */
  private Long lawAttachmentId;

  /**
   * 其它联系电话
   */
  private String contactPhone;
  private String contactType;


  /**
   * 当事人固定电话
   */
  private String telephone;

  private RegisterOriginEnum userRegisterOrigin;

  /**
   * 代理人列表
   */
  private List<CaseProtocolAgentPersonnelResDTO> agentList;

  public CaseProtocolPersonnelResDTO(MediationCasePersonnelDTO personnel) {
    this.documentId = personnel.getDocumentId();
    this.caseUserType = personnel.getCaseUserType();
    this.userId = personnel.getUserId();
    this.userType = personnel.getUserType();
    this.userName = personnel.getName();
    this.sex = personnel.getSex();
    this.phone = personnel.getPhone();
    this.idCard = personnel.getIdCard();
    this.provCode = personnel.getProvCode();
    this.cityCode = personnel.getCityCode();
    this.areaCode = personnel.getAreaCode();
    this.streetCode = personnel.getStreetCode();
    this.provName = personnel.getProvName();
    this.cityName = personnel.getCityName();
    this.areaName = personnel.getAreaName();
    this.streetName = personnel.getStreetName();
    this.address = personnel.getAddress();
    this.creditCode = personnel.getCreditCode();
    this.corporation = personnel.getCorporation();
    this.userOrder = personnel.getUserOrder();
    this.docAddress = personnel.getDocAddress();
    this.lawAttachmentId = personnel.getLawAttachmentId();
    this.contactPhone = personnel.getContactPhone();
    this.contactType = personnel.getContactType();
    this.telephone = personnel.getTelephone();
  }

}
